package model.temperature;

import model.AUnit;
import model.IBijection;

/**
 * Celsius temperature unit.
 *
 * @author Mathias Ricken
 */
public class Celsius extends AUnit {
    public Celsius() {
        super("C");
    }
    
    /**
     * Returns a function that converts a value in this temperature scale to a value in the "base temperature scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the Celsius scale, so the conversion function
        // is just the identity function
        return new IBijection<Double, Double>() {
            public IBijection<Double, Double> getInverse() {
                return this; // this is the identity function
            }
            
            public Double apply(Double param) {
                return param; // this is the identity function
            }
        };
    }
}
